package message

import "net"

type forwardAddr struct {
	network string
	value   string
}

var _ net.Addr = (*forwardAddr)(nil)

func NewForwardedAddr(network, value string) net.Addr {
	return &forwardAddr{network, value}
}

func (f *forwardAddr) Network() string { return f.network }
func (f *forwardAddr) String() string  { return f.value }
