package message

import (
	"fmt"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

const (
	readyLength = headerLength
)

type Ready interface {
	protocol.Message
}

type readyMessage struct{}

func NewReady() (Ready, error) {
	return &readyMessage{}, nil
}

func (*readyMessage) OpCode() protocol.OpCode { return protocol.Ready }
func (r *readyMessage) Marshal(ver protocol.Version) ([]byte, error) {
	if !ver.IsValid() {
		return nil, protocol.ErrInvalidVersion
	}
	bytes := make([]byte, readyLength)
	injectHeader(bytes, ver, r.OpCode())
	return bytes, nil
}

func (r *readyMessage) Unmarshal(ver protocol.Version, bytes []byte) error {
	if !ver.IsValid() {
		return protocol.ErrInvalidVersion
	}
	total := len(bytes)
	if total != readyLength {
		return protocol.ErrInvalidLength(readyLength, total)
	}
	return nil
}

func (r *readyMessage) String() string {
	return fmt.Sprintf("<%v>", r.OpCode())
}
