package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestReady(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		ready, err := NewReady()
		require.NoError(t, err)
		assert.Equal(t, protocol.Ready, ready.OpCode())
		assert.Equal(t, "<ready>", ready.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		ready, err := NewReady()
		require.NoError(t, err)
		bytes, err := ready.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, ready, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Ready).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Ready).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(readyLength, 0),
			createBlank(protocol.Ready).Unmarshal(protocol.Current, []byte{}))
	})
}
