package message

import (
	"fmt"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

const (
	rejectedLength = headerLength
)

type Rejected interface {
	protocol.Message
}

type rejectedMessage struct{}

func NewRejected() (Rejected, error) {
	return &rejectedMessage{}, nil
}

func (*rejectedMessage) OpCode() protocol.OpCode { return protocol.Rejected }
func (r *rejectedMessage) Marshal(ver protocol.Version) ([]byte, error) {
	if !ver.IsValid() {
		return nil, protocol.ErrInvalidVersion
	}
	bytes := make([]byte, rejectedLength)
	injectHeader(bytes, ver, r.OpCode())
	return bytes, nil
}

func (r *rejectedMessage) Unmarshal(ver protocol.Version, bytes []byte) error {
	if !ver.IsValid() {
		return protocol.ErrInvalidVersion
	}
	total := len(bytes)
	if total != rejectedLength {
		return protocol.ErrInvalidLength(rejectedLength, total)
	}
	return nil
}

func (r *rejectedMessage) String() string {
	return fmt.Sprintf("<%v>", r.OpCode())
}
