package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestRejected(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		rejected, err := NewRejected()
		require.NoError(t, err)
		assert.Equal(t, protocol.Rejected, rejected.OpCode())
		assert.Equal(t, "<rejected>", rejected.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		rejected, err := NewRejected()
		require.NoError(t, err)
		bytes, err := rejected.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, rejected, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Rejected).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Rejected).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(rejectedLength, 0),
			createBlank(protocol.Rejected).Unmarshal(protocol.Current, []byte{}))
	})
}
