package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestStatus(t *testing.T) {
	t.Run("should report values correctly", func(t *testing.T) {
		status, err := NewStatus(protocol.LoadFactor(123), protocol.Available)
		require.NoError(t, err)
		assert.Equal(t, protocol.Status, status.OpCode())
		assert.Equal(t, protocol.LoadFactor(123), status.LoadFactor())
		assert.Equal(t, protocol.Available, status.Flags())
		assert.Equal(t, "<status> flags=[available], load=123", status.String())
	})

	t.Run("should marshal correctly", func(t *testing.T) {
		status, err := NewStatus(protocol.LoadFactor(123), protocol.Available)
		require.NoError(t, err)
		bytes, err := status.Marshal(protocol.Current)
		require.NoError(t, err)
		out, err := Unmarshal(bytes)
		require.NoError(t, err)
		assert.Equal(t, status, out)
	})

	t.Run("should report version errors", func(t *testing.T) {
		_, err := createBlank(protocol.Status).Marshal(protocol.Unknown)
		assert.Equal(t, protocol.ErrInvalidVersion, err)
		assert.Equal(t, protocol.ErrInvalidVersion, createBlank(protocol.Status).Unmarshal(protocol.Unknown, []byte{}))
	})

	t.Run("should report length errors", func(t *testing.T) {
		assert.Equal(t, protocol.ErrInvalidLength(statusLength, 0),
			createBlank(protocol.Status).Unmarshal(protocol.Current, []byte{}))
	})
}
