package message

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

type OpaqueBytes = stream.OpaqueBytes

func Unmarshal(bytes []byte) (protocol.Message, error) {
	ver, op, ok := extractHeader(bytes)
	if !ok {
		return nil, protocol.ErrInvalidHeader
	}
	if msg := createBlank(op); msg != nil {
		if err := msg.Unmarshal(ver, bytes); err != nil {
			return nil, err
		}
		return msg, nil
	}
	return nil, protocol.ErrInvalidOpCode
}

func createBlank(op protocol.OpCode) protocol.Message {
	switch op {
	case protocol.Accept:
		return &acceptMessage{}
	case protocol.Accepted:
		return &acceptedMessage{}
	case protocol.Ack:
		return &ackMessage{}
	case protocol.Allocate:
		return &allocateMessage{}
	case protocol.Allocation:
		return &allocationMessage{}
	case protocol.AuthHost:
		return &authHostMessage{}
	case protocol.Bind:
		return &bindMessage{}
	case protocol.Connect:
		return &connectMessage{}
	case protocol.Detach:
		return &detachMessage{}
	case protocol.Detached:
		return &detachedMessage{}
	case protocol.Error:
		return &errorMessage{}
	case protocol.Failure:
		return &failureMessage{}
	case protocol.Forward:
		return &forwardMessage{}
	case protocol.Prepare:
		return &prepareMessage{}
	case protocol.Promise:
		return &promiseMessage{}
	case protocol.Ready:
		return &readyMessage{}
	case protocol.Rejected:
		return &rejectedMessage{}
	case protocol.Reserve:
		return &reserveMessage{}
	case protocol.Scopes:
		return &scopesMessage{}
	case protocol.Status:
		return &statusMessage{}
	case protocol.Ticket:
		return &ticketMessage{}
	case protocol.Validate:
		return &validateMessage{}
	}
	return nil
}
