package message

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestUnmarshal(t *testing.T) {
	t.Run("should report invalid header", func(t *testing.T) {
		_, err := Unmarshal([]byte{})
		assert.Equal(t, protocol.ErrInvalidHeader, err)
	})

	t.Run("should report invalid opcode", func(t *testing.T) {
		header := make([]byte, headerLength)
		require.True(t, injectHeader(header, protocol.Current, protocol.Invalid))
		_, err := Unmarshal(header)
		assert.Equal(t, protocol.ErrInvalidOpCode, err)
	})

	t.Run("should report invalid marshal", func(t *testing.T) {
		header := make([]byte, headerLength)
		require.True(t, injectHeader(header, protocol.Current, protocol.Ack))
		_, err := Unmarshal(header)
		assert.Equal(t, protocol.ErrInvalidLength(ackLength, headerLength), err)
	})
}
