package message

import (
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
)

const (
	headerLength = 4
)

func injectHeader(b []byte, ver protocol.Version, code protocol.OpCode) bool {
	if len(b) < 4 {
		return false
	}
	b[0] = 'D'
	b[1] = 'i'
	b[2] = byte(ver)
	b[3] = byte(code)
	return true
}

func extractHeader(b []byte) (protocol.Version, protocol.OpCode, bool) {
	if len(b) < 4 || b[0] != 'D' || b[1] != 'i' {
		return protocol.Unknown, protocol.Invalid, false
	}
	return protocol.Version(b[2]), protocol.OpCode(b[3]), true
}
