package protocol

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestOpCode(t *testing.T) {
	assert.False(t, Invalid.IsFromClient())
	assert.False(t, Invalid.IsFromService())
	assert.True(t, AuthHost.IsFromClient())
	assert.True(t, Ack.IsFromService())

	assert.Equal(t, "unknown: 12", OpCode(12).String())
}
