package protocol

// RequestID is used to track fulfillment of host requests sent by the discovery
// serve through a HostReporter interface. Services should expire association on
// a timeout and treat unacknowledged signals as failures.  The IDs are per
// service instance and must be associated with the session binding making the
// request to prevent collisions.

type RequestID uint32

const (
	NoRequestID    = RequestID(0) // zero value is not a valid request id; forces assignment
	FirstRequestID = RequestID(1)
)

// Next allows a safe sequence that wraps without ever returning NoRequest
func (t RequestID) Next() RequestID { return t + 2 }

// IsValid returns true if this is a valid RequestID
func (t RequestID) IsValid() bool { return t != NoRequestID }
