package protocol

import "strings"

type StatusFlags int8

const (
	NoFlags   StatusFlags = 0
	Available StatusFlags = 1 << 0 // the host is willing to accept more connections
	Draining  StatusFlags = 1 << 1 // the host is shutting down permanently
	Source    StatusFlags = 1 << 2 // the host is a data source; new addresses must be coordinated across sources
	Known                 = Available | Draining | Source
)

func (f StatusFlags) IsAvailable() bool { return (f & Available) != NoFlags }
func (f StatusFlags) IsDraining() bool  { return (f & Draining) != NoFlags }
func (f StatusFlags) IsSource() bool    { return (f & Source) != NoFlags }
func (f StatusFlags) String() string {
	segments := []string{}
	if f&Available == Available {
		segments = append(segments, "available")
	}
	if f&Draining == Draining {
		segments = append(segments, "draining")
	}
	if f&Source == Source {
		segments = append(segments, "source")
	}
	if f & ^Known != NoFlags {
		segments = append(segments, "unknown")
	}
	if len(segments) == 0 {
		return "none"
	}
	return strings.Join(segments, " | ")
}
