package protocol

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestStatusFalgs(t *testing.T) {
	assert.False(t, NoFlags.IsAvailable())
	assert.True(t, Available.IsAvailable())
	assert.False(t, Draining.IsAvailable())

	assert.False(t, NoFlags.IsDraining())
	assert.False(t, Available.IsDraining())
	assert.True(t, Draining.IsDraining())

	assert.False(t, NoFlags.IsSource())
	assert.False(t, Available.IsSource())
	assert.True(t, Source.IsSource())

	assert.Equal(t, "none", NoFlags.String())
	assert.Equal(t, "available", Available.String())
	assert.Equal(t, "available | draining | source", (Available | Source | Draining).String())
	assert.Equal(t, "available | source", (Available | Source).String())
	assert.Equal(t, "unknown", StatusFlags(16).String())
}
