package protocol

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestSuggestionID(t *testing.T) {
	assert.False(t, NoSuggestion.IsValid())
	sug := FirstSuggestion("test")
	assert.True(t, sug.IsValid())
	assert.Equal(t, sug.Next(), sug.Next()) // don't advance value in place
	assert.True(t, sug.Next().IsValid())
	bytes := []byte{}
	assert.Equal(t, ErrInvalidLength(sug.Len(), 0), sug.Marshal(bytes))
	out, err := UnmarshalSuggestion(bytes)
	assert.Equal(t, ErrInvalidLength(4, 0), err)
	assert.Nil(t, out)
	bytes = make([]byte, sug.Len())
	require.NoError(t, sug.Marshal(bytes))
	out, err = UnmarshalSuggestion(bytes)
	require.NoError(t, err)
	assert.Equal(t, sug, out)
	assert.Equal(t, "test#0", sug.String())
	assert.Equal(t, SuggestionKey("test#0"), sug.Key())

	assert.False(t, sug.Less(sug))
	assert.False(t, sug.Less(NoSuggestion))
	assert.False(t, sug.Less(nil))
	assert.True(t, sug.Less(sug.Next()))
	assert.True(t, NoSuggestion.Less(sug))
	assert.False(t, NoSuggestion.Less(NoSuggestion))
}
