package protocol

// Version tracks which message format and supported commands to use for each
// client.  Backward compatibility is maintained by downgrading communications
// on the service side to match the requested protocol. This is different from
// stream.Version, which is used to specify the format of the namespace specific
// content that is being served by this generic protocol.
type Version byte

const (
	Unknown       = Version(0) // zero value invalid
	One           = Version(1)
	Two           = Version(2)
	BroadcastSafe = Two // increment after all services can read forwarded messages
	Current       = Two
)

func (v Version) IsValid() bool { return v == One || v == Two }
