package api

import (
	"context"

	"code.justin.tv/devhub/e2ml/libs/discovery/broker/http"
	"code.justin.tv/devhub/e2ml/libs/discovery/service/auth"
	"code.justin.tv/devhub/e2ml/libs/discovery/service/data"
	"code.justin.tv/devhub/e2ml/libs/http/params"
	"code.justin.tv/devhub/e2ml/libs/stream"
)

func GetHost(ctx context.Context) (interface{}, error) {
	address, err := stream.ParseAddress(params.New(ctx).Get("address"))
	if err != nil {
		return nil, err
	}

	authReq := auth.Load(ctx)
	broker := data.Load(ctx)

	hostTicket, err := broker.FindHost(authReq, address)
	if err != nil {
		return nil, err
	}
	return http.NewGetHostResponse(hostTicket), nil
}
