package data

import (
	"context"
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/discovery"
)

var (
	brokerKey int // actual key is the address of this var
)

// StoreBroker builds a goji middleware that automatically places an
// Broker into the context of each request.
func StoreBroker(broker discovery.Broker) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := Store(r.Context(), broker)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

// Store places a broker into a context
func Store(ctx context.Context, broker discovery.Broker) context.Context {
	return context.WithValue(ctx, &brokerKey, broker)
}

// Load retrieves a broker from a context
func Load(ctx context.Context) discovery.Broker {
	if value, ok := ctx.Value(&brokerKey).(discovery.Broker); ok {
		return value
	}
	return defaultBrokerInstance
}
