package data

import (
	"context"
	"net/http"
	"testing"

	"code.justin.tv/devhub/e2ml/libs/discovery/broker/static"
	"code.justin.tv/devhub/e2ml/libs/discovery/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/empty"
	goji "goji.io"
	"goji.io/pat"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

type mockWriter struct {
	http.ResponseWriter
}

func TestLoadMissingManager(t *testing.T) {
	m := Load(context.Background())
	assert.NotNil(t, m)
	assert.Equal(t, defaultBrokerInstance, m)
}

func TestLoadCreatedConfig(t *testing.T) {
	var broker = static.NewBroker(empty.NewResolver(), nil, protocol.ErrForbidden)
	ctx := context.WithValue(context.Background(), &brokerKey, broker)
	out := Load(ctx)
	assert.NotNil(t, broker)
	assert.Equal(t, broker, out)
	assert.NotEqual(t, defaultBrokerInstance, out)
}

func TestStore(t *testing.T) {
	var broker = static.NewBroker(empty.NewResolver(), nil, protocol.ErrForbidden)
	ctx := Store(context.Background(), broker)
	assert.Equal(t, broker, Load(ctx))
}

func TestStoreManager(t *testing.T) {
	var broker = static.NewBroker(empty.NewResolver(), nil, protocol.ErrForbidden)
	called := false
	inner := http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		assert.Equal(t, broker, Load(r.Context()))
		called = true
	})
	server := goji.NewMux()
	server.Use(StoreBroker(broker))
	server.Handle(pat.Get("/"), inner)

	req, err := http.NewRequest("GET", "/", nil)
	require.NoError(t, err)
	server.ServeHTTP(new(mockWriter), req)
	assert.True(t, called)
}
