package errors

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGetErrorCode(t *testing.T) {
	t.Run("Should return empty by default", func(t *testing.T) {
		err := errors.New("raw")
		assert.Equal(t, "", GetErrorCode(err))
	})

	t.Run("Should work on a manually decorated error", func(t *testing.T) {
		err := errors.New("raw")
		err = WithErrorCode(err, "foo")
		assert.Equal(t, "foo", GetErrorCode(err))
	})

	t.Run("Should work on a built error", func(t *testing.T) {
		var err error = NewBuilder("message").WithErrorCode("bar").Build()
		err = WithErrorCode(err, "foo")
		assert.Equal(t, "foo", GetErrorCode(err))
	})
}
