package errors

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGetHTTPStatusOrDefault(t *testing.T) {
	t.Run("Should return default if not overridden", func(t *testing.T) {
		err := errors.New("raw")
		assert.Equal(t, -1, GetHTTPStatusOrDefault(err, -1))
	})

	t.Run("Should work on a manually decorated error", func(t *testing.T) {
		err := errors.New("raw")
		err = WithHTTPStatus(err, 304)
		assert.Equal(t, 304, GetHTTPStatusOrDefault(err, -1))
	})

	t.Run("Should work on a built error", func(t *testing.T) {
		var err error = NewBuilder("message").WithHTTPStatus(401).Build()
		err = WithHTTPStatus(err, 304)
		assert.Equal(t, 304, GetHTTPStatusOrDefault(err, -1))
	})
}
