package errors

import (
	"encoding/json"
	"io"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestMarshalAny(t *testing.T) {
	t.Run("should marshal errors", func(t *testing.T) {
		bytes, err := MarshalAny(io.EOF)
		require.NoError(t, err)
		assert.Equal(t, []byte(`{"message":"EOF"}`), bytes)
	})

	t.Run("should forward marshal errors", func(t *testing.T) {
		src := NewBuilder("x").WithDetails(Details{"x": &badMarshal{}}).Build()
		result, err := MarshalAny(src)
		assert.Nil(t, result)
		assert.IsType(t, &json.MarshalerError{}, err)
	})
}

func TestUnmarshalAny(t *testing.T) {
	t.Run("should unmarshal errors", func(t *testing.T) {
		var result error
		require.NoError(t, UnmarshalAny([]byte(`{"message":"EOF"}`), &result))
		assert.EqualError(t, result, "EOF")
	})

	t.Run("should forward unmarshal errors", func(t *testing.T) {
		var result error
		assert.IsType(t, &json.SyntaxError{}, UnmarshalAny([]byte("{{}"), &result))
		assert.Nil(t, result)
	})
}
