package http

import (
	"net"
	"time"
)

// sets TCP keepalive so that dead connections don't linger forever; based on
// code in "net/http"
type keepaliveListener struct {
	ln *net.TCPListener
}

var _ net.Listener = (*keepaliveListener)(nil)

func withKeepalive(ln *net.TCPListener) net.Listener {
	return &keepaliveListener{ln}
}

func (k *keepaliveListener) Addr() net.Addr { return k.ln.Addr() }
func (k *keepaliveListener) Close() error   { return k.ln.Close() }
func (k *keepaliveListener) Accept() (net.Conn, error) {
	conn, err := k.ln.AcceptTCP()
	if err == nil {
		conn.SetKeepAlive(true)
		conn.SetKeepAlivePeriod(time.Minute)
	}
	return conn, err
}
