package logging

type filter struct {
	level  int32
	output func(...interface{})
}

func NewFilter(level Level, output func(...interface{})) *filter {
	return &filter{int32(level), output}
}

func (f *filter) Log(level Level, msg ...interface{}) {
	if f.level <= int32(level) {
		f.output(msg...)
	}
}
