package devnull

import (
	"time"

	"code.justin.tv/devhub/e2ml/libs/metrics"
)

// NewTracker returns a metrics.Tracker that allows use of stats APIs but
// performs no actual work; it is used to "turn off" metrics.
func NewTracker() metrics.Tracker {
	return nullInstance
}

type nullTracker struct{}

var nullInstance = &nullTracker{}

func (*nullTracker) String() string                                 { return "{devnull metrics tracker}" }
func (*nullTracker) Close() error                                   { return nil }
func (*nullTracker) Tick()                                          {}
func (*nullTracker) Aggregator(string, []string) metrics.Aggregator { return nullInstance }
func (*nullTracker) Count(string, []string) metrics.Count           { return nullInstance }
func (*nullTracker) Timing(string, []string) metrics.Timing         { return nullInstance }
func (*nullTracker) Gauge(string, []string) metrics.Gauge           { return nullInstance }
func (*nullTracker) Add(int64)                                      {}
func (*nullTracker) Set(float64)                                    {}
func (*nullTracker) Sample(time.Duration)                           {}
