package metrics

// GoArgSource implements TagSource in a way compatible with the `github.com/alexflint/go-arg` library v1.2.0+
type GoArgSource struct {
	MetricsAccount string `arg:"--metrics-account,env:METRICS_ACCOUNT" default:"unknown"`
	MetricsService string `arg:"--metrics-service,env:METRICS_SERVICE" default:"unknown"`
	MetricsTaskARN string `arg:"--metrics-task-arn,env:METRICS_TASK_ARN" default:"unknown"`
}

func (g GoArgSource) GetTags() []string {
	return buildTags(g.MetricsAccount, g.MetricsTaskARN, g.MetricsService)
}
