package logged

import (
	"math"
	"sync/atomic"
)

type aggregator struct {
	k     string
	id    string
	value uint64
	prev  uint64
}

func (a *aggregator) Add(value int64) {
	for {
		prev := atomic.LoadUint64(&a.value)
		calc := math.Float64frombits(prev) + float64(value)
		if atomic.CompareAndSwapUint64(&a.value, prev, math.Float64bits(calc)) {
			return
		}
	}
}

func (a *aggregator) Set(value float64) {
	atomic.StoreUint64(&a.value, math.Float64bits(value))
}

func (a *aggregator) key() string { return a.k }

func (a *aggregator) tick() (string, float64, bool) {
	value := atomic.LoadUint64(&a.value)
	if prev := atomic.SwapUint64(&a.prev, value); prev != value {
		return a.id, math.Float64frombits(value), true
	}
	return "", 0, false
}
