package metrics

import (
	"flag"
	"os"
)

type TagSource interface {
	GetTags() []string
}

type tagSource struct {
	account *string
	service *string
	taskARN *string
}

func checkEnv(key, def string) string {
	if value, ok := os.LookupEnv(key); ok {
		return value
	}
	return def
}

func NewTagSource(flags *flag.FlagSet) TagSource {
	return &tagSource{
		account: flags.String("metrics-account", checkEnv("METRICS_ACCOUNT", "unknown"), "aws_account tag for metrics"),
		service: flags.String("metrics-service", checkEnv("METRICS_SERVICE", "unknown"), "service_name tag for metrics"),
		taskARN: flags.String("metrics-task-arn", checkEnv("METRICS_TASK_ARN", "unknown"), "task_arn of the ECS task running this service, for metrics"),
	}
}

func (t *tagSource) GetTags() []string { return buildTags(*t.account, *t.taskARN, *t.service) }

// buildTags common function is meant to keep all implementations in lockstep
func buildTags(account, taskARN, service string) []string {
	return []string{
		"aws_account:" + account,
		"task_arn:" + taskARN,
		"service_name:" + service,
	}
}
