package twitchtelemetry

import (
	"time"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	cw "code.justin.tv/amzn/TwitchTelemetryCloudWatchMetricsSender"
	"code.justin.tv/devhub/e2ml/libs/logging"
)

func SampleBuilderAndObserver(tPid identifier.ProcessIdentifier, interval time.Duration) (telemetry.SampleBuilder, telemetry.SampleObserver) {
	builder := telemetry.SampleBuilder{ProcessIdentifier: tPid}
	sender := cw.NewUnbuffered(&tPid, nil)
	observer := telemetry.NewBufferedAggregator(interval, 100000, time.Minute, sender, nil)
	return builder, observer
}

// Logger implements (code.justin.tv/amzn/TwitchLogging).Logger interface
// to be used by the telemetry.SampleReporter with a e2ml specific logging.Function
type Logger struct {
	Level  logging.Level
	Logger logging.Function
}

func (l *Logger) Log(msg string, keyvals ...interface{}) {
	keyvals = append([]interface{}{msg}, keyvals...)
	l.Logger(l.Level, keyvals...)
}
