package peering

import (
	"net/http"

	"code.justin.tv/devhub/e2ml/libs/errors"
)

const (
	ErrInvalidHandshakeCode     = "invalid_peer_handshake"
	ErrPeerAlreadyConnectedCode = "peer_already_connected"
	ErrPeerClosedCode           = "peer_closed"
	ErrPeerNotFoundCode         = "peer_not_found"
	ErrMissingHandshakeCode     = "missing_peer_handshake"
)

var (
	ErrInvalidHandshake = errors.NewBuilder("Invalid peer handshake").
				WithErrorCode(ErrInvalidHandshakeCode).
				WithHTTPStatus(http.StatusConflict).
				Build()
	ErrPeerClosed = errors.NewBuilder("Peer closed").
			WithErrorCode(ErrPeerClosedCode).
			WithHTTPStatus(http.StatusConflict).
			Build()
	ErrPeerNotFound = errors.NewBuilder("Peer not found").
			WithErrorCode(ErrPeerNotFoundCode).
			WithHTTPStatus(http.StatusNotFound).
			Build()
	ErrPeerAlreadyConnected = errors.NewBuilder("Peer already connected").
				WithErrorCode(ErrPeerAlreadyConnectedCode).
				WithHTTPStatus(http.StatusNotFound).
				Build()
	ErrMissingHandshake = errors.NewBuilder("Peer handshake expected").
				WithErrorCode(ErrMissingHandshakeCode).
				WithHTTPStatus(http.StatusConflict).
				Build()
)
