package hardcoded

import (
	"sync"

	"code.justin.tv/devhub/e2ml/libs/peering"
)

type serverList struct {
	addrs     []string
	local     string
	listeners map[peering.Listener]struct{}
	mutex     sync.Mutex
}

// NewServerList will immmediately report a hardcoded list to listeners when
// they are added
func NewServerList(local string, addrs []string) peering.ClosableServerList {
	return &serverList{local: local, addrs: addrs, listeners: make(map[peering.Listener]struct{})}
}

func (s *serverList) Close() error {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	addrs := s.addrs
	s.addrs = nil
	for _, name := range addrs {
		for listener := range s.listeners {
			listener.OnPeerRemoved(name)
		}
	}
	return nil
}

func (s *serverList) LocalName() string { return s.local }
func (s *serverList) WithLocal(name string) peering.ClosableServerList {
	return NewServerList(name, s.addrs)
}

func (s *serverList) RemoveListener(listener peering.Listener) {
	s.mutex.Lock()
	delete(s.listeners, listener)
	s.mutex.Unlock()
}

func (s *serverList) AddListener(listener peering.Listener) {
	s.mutex.Lock()
	addrs := s.addrs
	s.listeners[listener] = struct{}{}
	s.mutex.Unlock()
	for _, addrs := range addrs {
		listener.OnPeerAdded(addrs)
	}
}
