package hardcoded

import (
	"sync"
	"testing"

	"github.com/stretchr/testify/assert"
)

type testListener struct {
	found map[string]struct{}
	mutex sync.Mutex
	wg    sync.WaitGroup
}

func newTestListener() *testListener {
	return &testListener{found: make(map[string]struct{})}
}

func (t *testListener) OnPeerAdded(name string) {
	t.mutex.Lock()
	t.found[name] = struct{}{}
	t.wg.Done()
	t.mutex.Unlock()
}

func (t *testListener) OnPeerRemoved(name string) {
	t.mutex.Lock()
	delete(t.found, name)
	t.wg.Done()
	t.mutex.Unlock()
}

func TestServerList(t *testing.T) {
	list := NewServerList("x", []string{"x", "y"})
	assert.Equal(t, "x", list.LocalName())
	copy := list.WithLocal("one")
	x := newTestListener()
	x.wg.Add(2)
	list.AddListener(x)
	assert.Len(t, x.found, 2)
	_, ok := x.found["x"]
	assert.True(t, ok)
	_, ok = x.found["y"]
	assert.True(t, ok)
	x.wg.Add(2)

	y := newTestListener()
	y.wg.Add(2)
	list.AddListener(y)
	list.RemoveListener(y)

	assert.Equal(t, "one", copy.LocalName())
	assert.Equal(t, "x", list.LocalName())
	assert.NoError(t, copy.Close())

	assert.NoError(t, list.Close())
	assert.Empty(t, x.found)
	assert.Len(t, y.found, 2)
}
