package peering

import "code.justin.tv/devhub/e2ml/libs/logging"

type loggingListener struct {
	level  logging.Level
	logger logging.Function
}

var _ Listener = (*loggingListener)(nil)

// NewLoggingListener returns a listener that prints each peer added/removed to thelog
func NewLoggingListener(level logging.Level, logger logging.Function) Listener {
	return &loggingListener{level, logger}
}

func (l *loggingListener) OnPeerAdded(name string) {
	l.logger(l.level, "Peer [DISCOVERED]", name)
}

func (l *loggingListener) OnPeerRemoved(name string) {
	l.logger(l.level, "Peer [FORGOTTEN]", name)
}
