package peering

import "sync"

type queued struct {
	write func([]byte) error
	msg   []byte
}

type queue struct {
	queue []queued
	mutex sync.Mutex
}

func (q *queue) Append(msg []byte, write func([]byte) error) {
	bytes := make([]byte, len(msg))
	copy(bytes, msg)
	q.mutex.Lock()
	q.queue = append(q.queue, queued{write, bytes})
	q.mutex.Unlock()
}

func (q *queue) Flush() []queued {
	q.mutex.Lock()
	out := q.queue
	q.queue = nil
	q.mutex.Unlock()
	return out
}
