package peering

import (
	"io"
)

type ServerList interface {
	LocalName() string
	AddListener(listener Listener)
	RemoveListener(listener Listener)
}

type ClonableServerList interface {
	ServerList
	WithLocal(local string) ClosableServerList
}

type ClosableServerList interface {
	io.Closer
	ClonableServerList
}
