package echo

import (
	"code.justin.tv/devhub/e2ml/libs/session"
)

type server struct{}

func (*server) Factory() session.BindingFactory { return Factory }

func Server() session.Server { return &server{} }

// Factory implements session.Factory for a simple echo service
func Factory(client session.Client) session.Binding {
	return &binding{client}
}

// binding implements session.Binding for a simple echo service
type binding struct{ client session.Client }

func (b *binding) OnTextMessage(msg string)   { b.client.WriteText(msg) }
func (b *binding) OnBinaryMessage(msg []byte) { b.client.WriteBinary(msg) }
func (b *binding) OnClosed(error)             {} // no cleanup necessary
