package session

import "time"

// A Service defines an open endpoint that accepts clients
// Start() begins accepting new sessions
// Stop() stops accepting new sessions, but leaves existing ones open
// Shutdown() terminates all sessions for program shutdown
type Service interface {
	Start() error
	Stop()
	WaitForDrainingConnections(until time.Time)
	Shutdown() error

	IsRunning() bool
	HasShutdown() bool
}
