package setup

import (
	"time"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	poller "code.justin.tv/amzn/TwitchTelemetryPollingCollector"
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/metrics/twitchtelemetry"
)

func GoStatsCollector(tPid identifier.ProcessIdentifier, interval time.Duration, logger logging.Function) *poller.PollingCollector {
	builder, observer := twitchtelemetry.SampleBuilderAndObserver(tPid, interval)
	tLogger := &twitchtelemetry.Logger{Level: logging.Info, Logger: logger}

	return poller.NewGoStatsPollingCollector(interval, &builder, observer, tLogger)
}
