package setup

import (
	"fmt"
	"log"

	"code.justin.tv/devhub/e2ml/libs/logging"
)

func Logger(level logging.Level) logging.Function {
	return func(rlevel logging.Level, msg ...interface{}) {
		if rlevel < level {
			return
		}
		log.Output(2, rlevel.String()+" "+fmt.Sprintln(msg...))
	}
}
