package setup

import (
	"errors"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/metrics"
	"code.justin.tv/devhub/e2ml/libs/metrics/devnull"
	"code.justin.tv/devhub/e2ml/libs/metrics/logged"
	"code.justin.tv/devhub/e2ml/libs/metrics/twitchtelemetry"
)

func MetricsTracker(method string, tPid identifier.ProcessIdentifier, logger logging.Function) metrics.Tracker {
	var tracker metrics.Tracker = nil
	var err error = nil

	switch method {
	case "none":
		tracker = devnull.NewTracker()
	case "logged":
		tracker, err = logged.NewTracker("eml.", logging.Info, logger)
	case "twitchtelemetry":
		tracker = twitchtelemetry.NewTracker(tPid, logger)
	default:
		err = errors.New("unknown metrics method: " + method)
	}

	if err != nil {
		PanicWithMessage("Unable to initialize metrics", err)
	}
	return tracker
}
