package setup

import (
	"fmt"
	"net/url"
	"strings"
	"time"

	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/peering"
	"code.justin.tv/devhub/e2ml/libs/peering/dns"
	"code.justin.tv/devhub/e2ml/libs/peering/hardcoded"
)

func ServerList(method string, local string, data string, peerPort int, logger logging.Function) (peering.ClosableServerList, peering.NameResolver) {
	switch method {
	case "hardcoded":
		logger(logging.Info, "Using a hardcoded peer list; expects manual startup of each node at specified locations")
		list := []string{}
		if data != "" {
			list = strings.Split(data, ",")
		}
		return hardcoded.NewServerList(local, list), url.Parse
	case "dns":
		logger(logging.Info, "Using a DNS peer list, looking up", data, "with local value of", local)
		return dns.NewServerList(data, local, time.Second), func(host string) (*url.URL, error) {
			return &url.URL{
				Scheme: "ws",
				Host:   fmt.Sprintf("%s:%v", host, peerPort),
			}, nil
		}
	}
	panic("Unknown peer discovery method")
}
