package setup

import "crypto/tls"

func TLSConfig(certFile, keyFile string, insecure bool) *tls.Config {
	if certFile != "" || keyFile != "" {
		cer, err := tls.LoadX509KeyPair(certFile, keyFile)
		if err != nil {
			PanicWithMessage("Unable to load TLS config", err)
		}
		return &tls.Config{Certificates: []tls.Certificate{cer}, InsecureSkipVerify: insecure}
	}
	return nil
}
