package setup

import "net/url"

type URL url.URL

func (u *URL) UnmarshalText(value []byte) error {
	result, err := url.Parse(string(value))
	if err != nil {
		return err
	}
	*u = URL(*result)
	return nil
}

func Unwrap(u URL) *url.URL {
	val := url.URL(u)
	return &val
}
