package stream

// An Audience is used in the construction of ServerLogic as a sink for outbound
// messages that need to be sent from the service or source. The service can
// request an address-specific connection from the Audience to perform a series
// of consecutive updates directly to a particular resource. Unlike a standard
// listener, this Connection throws errors that allow for potential recovery by
// the service.
type Audience interface {
	LoadFactor() uint64 // weighted load since last call
	ForAddress(addr Address) (Topic, error)
	Enable(scopes AddressScopes)
	Disable(scopes AddressScopes)
}
