package audience

import (
	"sync"
	"sync/atomic"
	"unsafe"

	"code.justin.tv/devhub/e2ml/libs/stream"
)

type historySocket struct {
	ptr   unsafe.Pointer
	mutex sync.Mutex
}

type historyValue struct {
	value stream.History
	err   error
}

func (h *historySocket) load() (stream.History, error) {
	history, err, _ := h.get()
	return history, err
}

func (h *historySocket) get() (stream.History, error, bool) {
	if hist := (*historyValue)(atomic.LoadPointer(&h.ptr)); hist != nil {
		return hist.value, hist.err, true
	}
	return nil, nil, false
}

func (h *historySocket) loadOrCreate(addr stream.Address, logic stream.ServerLogic) (stream.History, error) {
	if history, err, found := h.get(); found {
		return history, err
	}
	h.mutex.Lock()
	defer h.mutex.Unlock()
	history, err, found := h.get()
	if !found {
		history, err = logic.GetHistory(addr)
		if err != nil {
			history = nil
		}
		atomic.StorePointer(&h.ptr, unsafe.Pointer(&historyValue{history, err}))
	}
	return history, err
}
