package audience

import (
	"code.justin.tv/devhub/e2ml/libs/promise"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol/message"
)

type receipt struct {
	l   *clientListener
	id  protocol.RequestID
	src promise.MutableAny
}

var _ stream.MutableTrackerPromise = (*receipt)(nil)

func newReceipt(l *clientListener, req protocol.Request) *receipt {
	return &receipt{l, req.RequestID(), promise.NewAny()}
}

func (r *receipt) WouldBlock() bool          { return r.src.WouldBlock() }
func (r *receipt) Get() (interface{}, error) { return r.src.Get() }
func (r *receipt) Result() (stream.Tracker, error) {
	result, err := r.src.Get()
	if cast, ok := result.(stream.Tracker); ok {
		return cast, err
	}
	return stream.Tracker(0), err
}

// Set synchronouslys sends ack/error back across the connection without needing
// a blocking gofunction, then allows other listeners to unblock.
func (r *receipt) Set(result stream.Tracker, err error) stream.MutableTrackerPromise {
	// TODO : resolve race condition: listener already closed
	if err == nil {
		src, pos := result.Current()
		r.l.respond(message.NewAck(r.id, src, pos))
	} else {
		r.l.respond(message.NewError(r.id, err))
	}
	r.src.Set(result, err)
	return r
}
