package composite

import (
	"strings"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type decoder struct {
	inner  []auth.Decoder
	method string
}

// NewExtractor returns an an extractor that attempts to use each internal one
// in turn until a match is found; if none of the values match the error return
// from the first supplied extractor is used. The method returned is the comma
// delimited list of methods that were originally supplied.
func NewDecoder(list ...auth.Decoder) auth.Decoder {
	var methods strings.Builder
	for i, r := range list {
		if i != 0 {
			methods.WriteRune(',')
		}
		methods.WriteString(r.Method())
	}
	return &decoder{list, methods.String()}
}

func (d *decoder) Method() string { return d.method }
func (d *decoder) Decode(code stream.OpaqueBytes) (stream.AuthRequest, bool) {
	for _, dec := range d.inner {
		if req, ok := dec.Decode(code); ok {
			return req, true
		}
	}
	return nil, false
}
