package composite

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/empty"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/extjwt"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/fake"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDecoder(t *testing.T) {
	t.Run("should return first match if possible", func(t *testing.T) {
		dec := NewDecoder(empty.NewDecoder(), fake.NewDecoder())
		assert.Equal(t, "empty,fake", dec.Method())
		req, ok := dec.Decode(nil)
		assert.True(t, ok)
		require.NotNil(t, req)
		assert.Equal(t, "empty", req.Method())

		dec = NewDecoder(fake.NewDecoder(), empty.NewDecoder())
		assert.Equal(t, "fake,empty", dec.Method())
		req, ok = dec.Decode(nil)
		assert.True(t, ok)
		require.NotNil(t, req)
		assert.Equal(t, "fake", req.Method())
	})

	t.Run("should iterate past failed matches", func(t *testing.T) {
		dec := NewDecoder(empty.NewDecoder(), fake.NewDecoder())
		req, ok := dec.Decode(stream.OpaqueBytes("token")) // not empty
		assert.True(t, ok)
		require.NotNil(t, req)
		assert.Equal(t, "fake", req.Method())
	})

	t.Run("should fail if nothing matches", func(t *testing.T) {
		jwt := extjwt.NewDecoder()
		dec := NewDecoder(jwt, empty.NewDecoder())

		req, ok := dec.Decode(stream.OpaqueBytes("code")) // not empty or jwt
		assert.False(t, ok)
		assert.Nil(t, req)
	})
}
