package composite

import (
	"net/http"
	"strings"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type extractor struct {
	inner  []auth.Extractor
	method string
}

// NewExtractor returns an an extractor that attempts to use each internal one
// in turn until a match is found; if none of the values match the error return
// from the first supplied extractor is used. The method returned is the comma
// delimited list of methods that were originally supplied.
func NewExtractor(list ...auth.Extractor) auth.Extractor {
	var methods strings.Builder
	for i, r := range list {
		if i != 0 {
			methods.WriteRune(',')
		}
		methods.WriteString(r.Method())
	}
	return &extractor{list, methods.String()}
}

func (e *extractor) Method() string { return e.method }
func (e *extractor) FailureReason(header http.Header) error {
	if len(e.inner) == 0 {
		return stream.ErrUnsupportedAuthMethod
	}
	return e.inner[0].FailureReason(header)
}

func (e *extractor) Extract(header http.Header) (stream.AuthRequest, bool) {
	for _, ext := range e.inner {
		if req, ok := ext.Extract(header); ok {
			return req, true
		}
	}
	return nil, false
}
