package composite

import (
	"strings"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth"
)

type resolver struct {
	inner  map[string]auth.Resolver
	method string
}

// NewResolver bundles multiple resolvers together and uses Method() to
// determine which one should be used. The method function of the composite
// reports a comma delimited list of the innner resolvers' methods for debugging
// purposes.
func NewResolver(list ...auth.Resolver) auth.Resolver {
	inner := make(map[string]auth.Resolver)
	var methods strings.Builder
	for i, r := range list {
		if i != 0 {
			methods.WriteRune(',')
		}
		methods.WriteString(r.Method())
		inner[r.Method()] = r
	}
	return &resolver{inner, methods.String()}
}

func (r *resolver) Method() string { return r.method }
func (r *resolver) Resolve(req stream.AuthRequest) (stream.Credentials, error) {
	if res, ok := r.inner[req.Method()]; ok {
		return res.Resolve(req)
	}
	return nil, stream.ErrUnsupportedAuthMethod
}
