package composite

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/empty"
	"code.justin.tv/devhub/e2ml/libs/stream/auth/fake"
	"github.com/stretchr/testify/assert"
)

func TestResolver(t *testing.T) {
	t.Run("should resolve if a match is found", func(t *testing.T) {
		res := NewResolver(empty.NewResolver(), fake.NewResolver(stream.AllPermissions(), nil))
		assert.Equal(t, "empty,fake", res.Method())

		creds, err := res.Resolve(empty.NewRequest())
		assert.Equal(t, stream.NoPermissions(), creds)
		assert.NoError(t, err)

		creds, err = res.Resolve(fake.NewRequest())
		assert.Equal(t, stream.AllPermissions(), creds)
		assert.NoError(t, err)
	})

	t.Run("should reject if a match is not found", func(t *testing.T) {
		res := NewResolver(empty.NewResolver())

		creds, err := res.Resolve(fake.NewRequest())
		assert.Nil(t, creds)
		assert.Equal(t, stream.ErrUnsupportedAuthMethod, err)
	})

	t.Run("should forward errors if a match is found", func(t *testing.T) {
		res := NewResolver(fake.NewResolver(nil, stream.ErrForbidden))
		creds, err := res.Resolve(fake.NewRequest())
		assert.Nil(t, creds)
		assert.Equal(t, stream.ErrForbidden, err)
	})
}
